--mounting 3d model paths and texture paths 

mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/p38d")
--mount_vfs_sound_path    (current_mod_path.."/Sounds")

--Ammunition MG 131
local tracer_on_time = 0.01
declare_weapon({category = CAT_SHELLS,name =   "MG_13x64_APT",
  user_name		= _("MG_13x64_APT"),
  model_name    = "tracer_bullet_green",
  v0    		= 710.0,
  Dv0   		= 0.0080,
  Da0    		= 0.0004,
  Da1     		= 0.0,
  mass      	= 0.038,
  round_mass 	= 0.09,
  explosive     = 0.0000,
  life_time     = 7,
  caliber     	= 13,
  s         	= 0.0,
  j         	= 0.0,
  l         	= 0.0,
  charTime      = 0,
  cx        	= {1.0,0.912,0.7,0.25,1.80},
  k1        	= 4.8e-08,
  tracer_off    = 1.5,
  tracer_on		= tracer_on_time,
  smoke_tail_life_time = 0.5,
  scale_tracer  = 1,
  cartridge 	= 0,
})
declare_weapon({category = CAT_SHELLS,name =   "MG_13x64_API",
  user_name		= _("MG_13x64_API"),
  model_name    = "tracer_bullet_yellow",
  v0    		= 750.0,
  Dv0   		= 0.0080,
  Da0    		= 0.0004,
  Da1     		= 0.0,
  mass      	= 0.034,
  round_mass 	= 0.086,
  explosive     = 0.0000,
  life_time     = 7,
  caliber     	= 13,
  s         	= 0.0,
  j         	= 0.0,
  l         	= 0.0,
  charTime      = 0,
  cx        	= {1.0,0.912,0.7,0.25,1.80},
  k1        	= 4.3e-08,
  tracer_off    = -1,
  tracer_on		= tracer_on_time,
  scale_tracer  = 0,
  cartridge 	= 0,
})
declare_weapon({category = CAT_SHELLS,name =   "MG_13x64_HEI",
  user_name		= _("MG_13x64_HEI"),
  model_name    = "tracer_bullet_white",
  v0    		= 750.0,
  Dv0   		= 0.0080,
  Da0    		= 0.0004,
  Da1     		= 0.0,
  mass      	= 0.034,
  round_mass 	= 0.086,
  explosive     = 0.0070,
  life_time     = 7,
  caliber     	= 13,
  s         	= 0.0,
  j         	= 0.0,
  l         	= 0.0,
  charTime      = 0,
  cx        	= {1.0,0.912,0.7,0.25,1.80},
  k1        	= 4.3e-08,
  tracer_off    = -1,
  tracer_on		= tracer_on_time,
  scale_tracer  = 0,
  cartridge 	= 0,
})

--Ammunition MG 151/20
declare_weapon({category = CAT_SHELLS,name =   "MG_20x82_HEI_T",
  user_name		= _("MG_20x82_HEI_T"),
  model_name    = "tracer_bullet_crimson",
  v0    		= 705.0,
  Dv0   		= 0.0080,
  Da0    		= 0.0004,
  Da1     		= 0.0,
  mass      	= 0.115,
  round_mass 	= 0.22,
  explosive     = 0.009,
  life_time     = 7,
  caliber     	= 20,
  s         	= 0.0,
  j         	= 0.0,
  l         	= 0.0,
  charTime      = 0,
  cx        	= {0, 0.77, 0.8, 0.23, 2.3},
  k1        	= 2e-08,
  tracer_off    = 3,
  tracer_on		= tracer_on_time,
  smoke_tail_life_time = 0.7,
  scale_tracer  = 1,
  cartridge 	= 0,
})
declare_weapon({category = CAT_SHELLS,name =   "MG_20x82_API",
  user_name		= _("MG_20x82_API"),
  model_name    = "tracer_bullet_yellow",
  v0    		= 705.0,
  Dv0   		= 0.0080,
  Da0    		= 0.0004,
  Da1     		= 0.0,
  mass      	= 0.115,
  round_mass 	= 0.22,
  explosive     = 0.009,
  life_time     = 7,
  caliber     	= 20,
  s         	= 0.0,
  j         	= 0.0,
  l         	= 0.0,
  charTime      = 0,
  cx        	= {0, 0.77, 0.8, 0.23, 2.3},
  k1        	= 2e-08,
  tracer_off    = -1,
  tracer_on		= tracer_on_time,
  scale_tracer  = 0,
  cartridge 	= 0,
})
declare_weapon({category = CAT_SHELLS,name =   "MG_20x82_MGsch",
  user_name		= _("MG_20x82_MGsch"),
  model_name    = "tracer_bullet_white",
  v0    		= 760.0,
  Dv0   		= 0.0080,
  Da0    		= 0.0004,
  Da1     		= 0.0,
  mass      	= 0.095,
  round_mass 	= 0.19,
  explosive     = 0.035,
  life_time     = 7,
  caliber     	= 20,
  s         	= 0.0,
  j         	= 0.0,
  l         	= 0.0,
  charTime      = 0,
  cx        	= {0,0.92,0.75,0.25,1.7},
  k1        	= 4.0e-08,
  tracer_off    = -1,
  tracer_on		= tracer_on_time,
  scale_tracer  = 0,
  cartridge 	= 0,
})

function MG_131(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "MG_131"
	tbl.supply 	 = 
	{
		shells = {"MG_13x64_APT","MG_13x64_API","MG_13x64_HEI"},
		mixes  = {{1,2,3,1,2,3}}, --  
		count  = 475,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 150,
		rates 			 = {900},-- unsync mount
		recoil_coeff 	 = 1.0,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 		= tbl.ejector_pos or {0.0, 0.05, 0.0}
	tbl.ejector_dir 		= {0,-1,0}
	tbl.effect_arg_number	= tbl.effect_arg_number or 436
	tbl.supply_position  	= tbl.supply_position   or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1000
	tbl.drop_cartridge 			= 204
	tbl.muzzle_pos				= {0,0,0} -- all position from connector
	tbl.azimuth_initial 		=  tbl.azimuth_initial  or 0   
	tbl.elevation_initial 		=  tbl.elevation_initial  or 0   
	
	return declare_weapon(tbl)
end

function MG_151_20(tbl)
	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "MG_151_20"
	tbl.supply 	 = 
	{
		shells = {"MG_20x82_HEI_T","MG_20x82_API","MG_20x82_MGsch"},
		mixes  = {{1,2,3,1,2,3}}, --  
		count  = 250,
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 150,
		rates 			 = {700},-- unsync mount
		recoil_coeff 	 = 1.0,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 		= tbl.ejector_pos or {0.0, 0.05, 0.0}
	tbl.ejector_dir 		= {0,-1,0}
	tbl.effect_arg_number	= tbl.effect_arg_number or 436
	tbl.supply_position  	= tbl.supply_position   or {0, -0.3, -1.5}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1000
	tbl.drop_cartridge 			= 204
	tbl.muzzle_pos				= {0,0,0} -- all position from connector
	tbl.azimuth_initial 		=  tbl.azimuth_initial  or 0   
	tbl.elevation_initial 		=  tbl.elevation_initial  or 0   
	
	return declare_weapon(tbl)
end
 


P_38D =  {
        
	Name 				=   'P-38D',
	DisplayName			= _('P-38D'),
	
	HumanCockpit 		= true,
	HumanCockpitPath    = current_mod_path..'/Cockpit/',
	
	Picture 			= "p38d.png",
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "p38d",
	
	shape_table_data 	= 
	{
		{
			file  	 	= 'p38d';
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'p38d-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'P-38D';
			index    	=  WSTYPE_PLACEHOLDER;
			classname 	= "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
		{
			name  = "p38d-oblomok";
			file  = "p38d-oblomok";
			fire  = { 240, 2};
		},

	},
	mapclasskey 		= "P0091000025",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER ,"Battleplanes",},
	Categories 			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},	
	-------------------------
	M_empty 					= 4550, -- kg
	M_nominal 					= 6750, -- kg
	M_max 						= 7212, -- kg
	M_fuel_max 					= 732, -- kg --2225
	H_max 					 	= 11800, -- m
	stores_number				=	0,
	average_fuel_consumption 	= 0.55, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	CAS_min 					= 50, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	V_opt 						= 134,-- Cruise speed (for AI)
	V_take_off 					= 53, -- Take off speed in m/s (for AI)
	V_land 						= 50, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 155, -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 177, -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 16, -- Max climb speed in m/s (for AI)
	Mach_max 					= 0.8, -- Max speed in Mach (for AI)
	Ny_min 						= -4, -- Min G (for AI)
	Ny_max 						= 8.0,  -- Max G (for AI)
	Ny_max_e 					= 8.0,  -- Max G (for AI)
	AOA_take_off 				= 0.16, -- AoA in take off (for AI)
	bank_angle_max 				= 60, -- Max bank angle (for AI)
	has_afteburner 				= false, -- AFB yes/no
	has_speedbrake 				= false, -- Speedbrake yes/no

-------- Posizione rispetto al suolo ----------------------------	
------- Valori di Mario	
	 nose_gear_pos				= 	{3.769,	-1.800,	0}, -- nosegear coord 3.769,	-2.353,	0
	 nose_gear_amortizer_direct_stroke   		         =  0,  -- down from nose_gear_pos !!!
	 nose_gear_amortizer_reversal_stroke  		=  0,  -- up 
	 nose_gear_amortizer_normal_weight_stroke 	=  0,   -- up 
	 nose_gear_wheel_diameter 	               			 = 0.615, -- in m
	
	 main_gear_pos 				= 	{0.090,	-1.780, -2.374}, -- main gear coords 0.072,	-2.374,	2.341
	 main_gear_amortizer_direct_stroke	 	    =   0, --  down from main_gear_pos !!!
	 main_gear_amortizer_reversal_stroke  	    = 	0, --  up 
	 main_gear_amortizer_normal_weight_stroke    =   0,-- down from main_gear_pos
	 main_gear_wheel_diameter 				    =   0.79, -- in m

---------------------------------------------------------------------------------------------------------

	
	tand_gear_max				= 0.577,
	tanker_type 				= 0, -- Tanker type if the plane is airrefuel capable
	wing_area 					= 30.43, -- wing area in m2
	wing_span 					= 15.85, -- wing spain in m
	wing_type 					= 0,
	thrust_sum_max 				= 16000, -- thrust in kg (44kN)
	thrust_sum_ab 				= 16000, -- thrust inkg (71kN)
	length 						= 11.53, -- full lenght in m
	height 						= 3.91, -- height in m
	flaps_maneuver 				= 0.75, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	range 						= 1448, -- Max range in km (for AI)
	RCS 						= 3, -- Radar Cross Section m2
	IR_emission_coeff 			= 0.2, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 0, -- With afterburner
	wing_tip_pos 				= 	{0.532,	0.328,	6.171}, -- wingtip coords for visual effects
--	nose_gear_wheel_diameter 	= 0.604, -- in m
--	main_gear_wheel_diameter 	= 0.157, -- in m
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= {0, 0, 0}, -- refuel coords
	engines_count				= 2, -- Engines count
	engines_nozzles = {
		[1] = 
		{
			pos 		=  {0.211,-0.207, 2.796}, -- nozzle coords
			elevation   =  0, -- AFB cone elevation
			diameter	 = 0.3, -- AFB cone diameter
			exhaust_length_ab   = 0.631, -- lenght in m
			exhaust_length_ab_K = 0.56, -- AB animation
			smokiness_level = 0.08,
			engine_number  = 1, --both to first engine
		}, -- end of [1]
		[2] = 
		{
			pos 		=  {0.211,-0.207, -2.796}, -- nozzle coords
			elevation   =  0, -- AFB cone elevation
			diameter	 = 0.3, -- AFB cone diameter
			exhaust_length_ab   = 0.631, -- lenght in m
			exhaust_length_ab_K = 0.56, -- AB animation
			smokiness_level = 0.08,
			engine_number  = 2, --both to first engine
		}, -- end of [1]
	}, -- end of engines_nozzles
	crew_members = 
	{
		[1] = 
		{
			pilot_name		  	 = "pilot_p51",
			ejection_seat_name	 = 0,
			drop_canopy_name 	 = "p38d_canopy",
			pos					 =  {-0.20,-0.045000,0.000000},
			canopy_pos = {0,0,0},
		}, -- end of [1]
	}, -- end of crew_members
	
--First  value: forward / backward
--second value: up / down
--third  value: left / right	

	fires_pos = 
		{
			[1] = 	{-2,	-1,		0.5},
			[2] = 	{-1,	-1,		2.237},
			[3] = 	{-1,	-1,		-2.237},
			[4] = 	{0.265,	-1,		1.5},
			[5] = 	{-2.6,	-1,		0.2},
			[6] = 	{0.5,	-1,		1.274},
			[7] = 	{0.5,	-1.3,	-1.274},
			[8] = 	{-1,	-1,		0},
			[9] = 	{-3.5,	-1.5,		0},
			[10] = 	{-2.5,	-1.1,		0},
			[11] = 	{-1,	-1.2,		0},
		}, -- end of fires_pos
	
	
	-- Countermeasures
	SingleChargeTotal	 	= 0,
	CMDS_Incrementation 	= 0,
	ChaffDefault 			= 0, 
	ChaffChargeSize 		= 0,
	FlareDefault 			= 0, 
	FlareChargeSize 		= 0,
	CMDS_Edit 				= false,

	--sensors
	
	detection_range_max		 = 0,
	radar_can_see_ground 	 = false, -- this should be examined (what is this exactly?)
	CanopyGeometry = {
		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
		elevation = {-50.0, 90.0} -- pilot view vertical (AI)
	},
	Sensors = {},
	HumanRadio = {
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},
	
	
	Guns =  {
			MG_131({muzzle_pos_connector	= "Gun_point_4",rates = {875},effect_arg_number = 435,mixes = {{1,2,3,2}},azimuth_initial = 0		,elevation_initial = 0.385,supply_position = {6.000,  -1.144, -0.678}}), --L
			MG_131({muzzle_pos_connector	= "Gun_point_5",rates = {883},effect_arg_number = 432,mixes = {{3,2,1,2}},azimuth_initial = 0		,elevation_initial = 0.385,supply_position = {6.000,  -1.085,  0.568}}), --R
			MG_151_20({muzzle_pos_connector	= "Gun_point_1",rates = {688},effect_arg_number = 436,mixes = {{1,2,2,3,3}},azimuth_initial = -0.092,elevation_initial = 0.563,supply_position = {6.000, -1.085, -0.568}}), --L
			MG_151_20({muzzle_pos_connector	= "Gun_point_2",rates = {688},effect_arg_number = 436,mixes = {{1,2,2,3,3}},azimuth_initial = -0.092,elevation_initial = 0.563,supply_position = {6.000, -1.085, -0.568}}), --L
			MG_151_20({muzzle_pos_connector	= "Gun_point_3",rates = {679},effect_arg_number = 350,mixes = {{3,3,1,2,2}},azimuth_initial =  0.092,elevation_initial = 0.563,supply_position = {6.000, -1.144,  0.678}}), --R			
			},



--------------------------------------------------------------------------------------------
--        Pylon type P51D Start 
---------------------------------------------------------------------------------------------			
	Pylons =  {  
		pylon(1, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_1",arg = 314,arg_value = -1.0},
		{
			{ CLSID = "{HVAR}",arg = 314,arg_value = 0.5},
			{ CLSID = "{HVAR_SMOKE_GENERATOR}",arg = 314,arg_value =  0.5},
		}),
		pylon(2, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_2",arg = 313,arg_value = -1.0},
		{
			{ CLSID = "{HVAR}",arg = 313,arg_value = 0.5 },
		}),
		pylon(3, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_3",arg = 312,arg_value = -1.0},
		{
			{ CLSID = "{HVAR}",arg = 312,arg_value = 0.5 },
		}),
		pylon(4, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_5", },
		{
			{ CLSID = "{AN-M64}" ,connector = "PYLON_4_B",arg = 308,arg_value = 0.5 , forbidden = {{station = 5, loadout = {"{HVAR}"}}}},
			{ CLSID = "{DT75GAL}",connector = "PYLON_4_B",arg = 308,arg_value = 0.5 , forbidden = {{station = 5, loadout = {"{HVAR}"}}}},
			{ CLSID = "{HVAR}" 							 ,arg = 308,arg_value = 1.0},

		}),
		pylon(5, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_6"},
		{
		--	{ CLSID = "{HVAR}",arg = 309,arg_value = 1.0}
		}),
		pylon(6, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_7"},
		{
		--	{ CLSID = "{HVAR}",arg = 310,arg_value = 1.0}
		}),
		pylon(7, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_8"},
		{
			{ CLSID = "{AN-M64}" ,connector = "PYLON_9_B",arg = 311,arg_value = 0.5, forbidden = {{station = 6, loadout = {"{HVAR}"}}}},
			{ CLSID = "{DT75GAL}",connector = "PYLON_9_B",arg = 311,arg_value = 0.5, forbidden = {{station = 6, loadout = {"{HVAR}"}}}},
			{ CLSID = "{HVAR}"	                         ,arg = 311,arg_value = 1.0},
		}),
		pylon(8, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_10",arg = 315,arg_value = -1.0},
		{
			{ CLSID = "{HVAR}" ,arg = 315,arg_value = 0.5},
		}),
		pylon(9, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_11",arg = 316,arg_value = -1.0},
		{
			{ CLSID = "{HVAR}",arg = 316,arg_value =  0.5},
		}),
		pylon(10, 0, 0, 0, 0, {use_full_connector_position=true,connector = "PYLON_12",arg = 317,arg_value = -1.0},
		{
			{ CLSID = "{HVAR}",arg = 317,arg_value =  0.5},
			{ CLSID = "{HVAR_SMOKE_GENERATOR}",arg = 317,arg_value =  0.5},
		}),
	},
 
--------------------------------------------------------------------------------------------
--        Pylon type P51D End
---------------------------------------------------------------------------------------------	
--------------------------------------------------------------------------------------------------------------------------	
	Tasks = {
			aircraft_task(CAP),
			aircraft_task(Escort),
			aircraft_task(FighterSweep),
			aircraft_task(GroundAttack),
			aircraft_task(CAS),
			aircraft_task(AFAC),
			aircraft_task(RunwayAttack),
			aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(CAS),
   
	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0			=	0.2,      -- zero AoA lift coefficient
			Mzalfa		=	4.355,  -- coefficients for pitch agility
			Mzalfadt	=	0.8,    -- coefficients for pitch agility
			kjx			=	2.25,    
			kjz			=	0.00125, 
			Czbe		=	-0.016, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.012,    -- coefficient, drag, gear 0.0277
			cx_flap		=	0.05,   -- coefficient, drag, full flaps
			cy_flap		=	0.8,    -- coefficient, normal force, lift, flaps
			cx_brk		=	0.06,   -- coefficient, drag, breaks
			table_data  = 
			{	--        M		 Cx0	 Cya	  B		 B4	    Omxmax	   Aldop   Cymax
						{0.0,	0.0187,	0.0746,		0.052,	0.012,	0.15,		22.0,		1.45,	},
						{0.2,	0.0187,	0.0746,		0.052,	0.012,	0.796144,	22.0,		1.45,   },
						{0.3,	0.0187,	0.0722,		0.052,	0.015,	1.24,		19.0,		1.2,    },
						{0.5,	0.0187,	0.0798,		0.045,	0.025,	1.323,		17.0,		1.08,   },
						{0.59,	0.0187,	0.084,		0.047,	0.026,	1.129077,	17.0,		1.07,   },
						{0.67,	0.0187,	0.0907,		0.047,	0.021,	0.943,		14.5,		0.98,   },
						{0.74,	0.0227,	0.0855,		0.08,	0.16,	0.675,		10.0,	  	0.72,   },
						{0.76,	0.032,	0.078,		0.1,	0.25,	0.577,		9.0,  		0.6,    },
						{0.8,	0.063,	0.072,		0.2,	0.36,	0.456,		6.0,	    0.4,	},
						{0.83,	0.1,	0.0725,		0.34,	2.4,	0.32,		4.5,		0.3,	},
						{0.9,	0.126,	0.073,		0.56,	3.0,	0.076,		3.0,	    0.2,	},
						{1.1,	0.16,	0.03,		0.56,	3.0,	0.076,		1.0,		0.3		},
			
			}, -- end of table_data
			
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	67.5, -- RPM at idle
			MinRUD	=	0, -- Min state of the throttle
			MaxRUD	=	1, -- Max state of the throttle
			MaksRUD	=	1, -- Military power state of the throttle
			ForsRUD	=	1, -- Afterburner state of the throttle
			typeng	=	2,
			--[[
				E_TURBOJET = 0
				E_TURBOJET_AB = 1
				E_PISTON = 2
				E_TURBOPROP = 3
				E_TURBOFAN	= 4
				E_TURBOSHAFT = 5
			--]]
			
			hMaxEng	=	12.5, -- Max altitude for safe engine operation in km
			dcx_eng	=	0.0015, -- Engine drag coeficient
			cemax	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	1800, --  altitude coefficient for max thrust
			dpdh_f	=	1800,  --  altitude coefficient for AB thrust
			k_adiab_1			= 0.037923,
			k_adiab_2			= 0.0562,
			MAX_Manifold_P_1	= 155774,		
			MAX_Manifold_P_2	= 206570,		
			MAX_Manifold_P_3	= 226648,		
			k_after_cool		= 0.54,
			Displ				= 27,
			k_Eps				= 6,
			Stroke				= 0.152,
			V_pist_0			= 12,
			Nu_0				= 1.2,
			Nu_1				= 0.9,
			Nu_2				= 0.001,
			N_indic_0			= 1023040,
			N_fr_0				= 0.072,
			N_fr_1				= 0.02,
			Init_Mom			= 220,
			D_prop				= 3.45,
			MOI_prop			= 65,
			k_gearbox			= 2.088,
			P_oil				= 495438,
			k_boost				= 3,
			k_cfug				= 0.003,
			k_oil				= 0.00004,
			k_piston			= 3000,
			k_reg				= 0.003,
			k_vel				= 0.017,
			
			table_data = 
			{		--   M		Pmax		 Pfor	
			
			--   M			Pmax
				{0.0,		33240.0},
				{0.1,		31200.0},
				{0.2,		28680.0},
				{0.3,		26640.0},
				{0.4,		24460.0},
				{0.5,		22600.0},
				{0.6,		21200.0},
				{0.7,		20100.0},
				{0.8,		19640.0},
				{0.9,		11804.0},
				{1.9,		9938.0},
			}
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
		}, -- end of engine
	},
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
				[0]		= {critical_damage = 5, args = {146}},
				[3]		= {critical_damage = 10,args = {65}}  ,
				[4]		= {critical_damage = 10, args = {150}},
				[5]		= {critical_damage = 10, args = {147}},
				[7]		= {critical_damage = 4, args = {249}} ,
				[9]		= {critical_damage = 3, args = {154}},
				[10]	= {critical_damage = 3, args = {153}},
				[11]	= {critical_damage = 3, args = {167}},
				[12]	= {critical_damage = 3, args = {161}},
				[15]	= {critical_damage = 5, args = {267}},
				[16]	= {critical_damage = 5, args = {266}},
				[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
				[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
				[25]	= {critical_damage = 3, args = {226}},
				[26]	= {critical_damage = 3, args = {216}},
				[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
				[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
				[31]	= {critical_damage = 4, args = {229}},
				[32]	= {critical_damage = 4, args = {219}},
				[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
				[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
				[37]	= {critical_damage = 4, args = {227}},
				[38]	= {critical_damage = 4, args = {217}},
				[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
				[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
				[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
				[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
				[51]	= {critical_damage = 3, args = {239}},
				[52]	= {critical_damage = 3, args = {237}},
				[53]	= {critical_damage = 3, args = {248}},
				[54]	= {critical_damage = 3, args = {247}},
				[55]	= {critical_damage = 10, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
				[59]	= {critical_damage = 5, args = {148}},
				[60]	= {critical_damage = 1, args = {144}},

				[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
				[84]	= {critical_damage = 3, args = {136}}, -- left wheel
				[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
				[55]	 = {critical_damage = 10, args = {81}},
				[57]	= {critical_damage = 10, args = {157}},-- tail right
				[61] = {critical_damage = 3}, --fuel tank front (left)
				[62] = {critical_damage = 3}, --fuel tank back (right)					
--------- Rotor/Propeller ---------------------------------------------------------
				[66]		= {critical_damage = 3, args = {270}}, -- blade 1 out
				[69]		= {critical_damage = 3, args = {271}}, -- blade 2 out
				[72]		= {critical_damage = 3, args = {272}}, -- blade 3 out
				[75]		= {critical_damage = 3, args = {273}}, -- blade 4 out
				[64]		= {critical_damage = 3, args = {429}}, -- blade 1 in  (for contact model!)
				[67]		= {critical_damage = 3, args = {430}}, -- blade 2 in  (for contact model!)
				[70]		= {critical_damage = 3, args = {431}}, -- blade 3 in  (for contact model!)
				[73]		= {critical_damage = 3, args = {119}}, -- blade 4 in  (for contact model!)				
	},
	
	DamageParts = 
	{  
		[1] = "p38d-oblomok-wing-r", -- wing R
		[2] = "p38d-oblomok-wing-l", -- wing L
		[3] = "p38d-oblomok-tail-l", -- nose
		[4] = "p38d-oblomok-tail-r", -- tail
	},
	
	lights_data = {	typename = "collection", lights = {
    [1] = {typename = "collection",lights = {}},
	[2] = {typename = "collection",
			lights = {-- Landing light
					  {typename = "spotlight",
					   connector = "MAIN_SPOT_PTR_02",
					   argument = 209,
					   dir_correction = {elevation = math.rad(-1)}
					  },
					  {-- Landing/Taxi light
					   typename = "spotlight",
					   connector = "MAIN_SPOT_PTR_01",
					   argument = 208,
					   dir_correction = {elevation = math.rad(3)}
					  }
					 }
			},
    [3]	= {typename = "collection",
			lights = {-- Left Position Light (red)
					  {typename = "omnilight",
					   connector = "BANO_1",
					   color = {0.99, 0.11, 0.3},
					   pos_correction  = {0, 0, -0.2},
					   argument  = 190
					  },
					  -- Right Position Light (green)
					  {typename = "omnilight",
					   connector = "BANO_2",
					   color = {0, 0.894, 0.6},
					   pos_correction = {0, 0, 0.2},
					   argument  = 191
					   },
					  -- Tail Position Light (white)
					  {typename = "omnilight",
					  connector = "BANO_0",
					  color = {1, 1, 1},
					  pos_correction  = {0, 0, 0},
					  argument  = 192
					  }}
			},
    [4] = {typename = "collection",lights = {}},
	[5]	= {typename = "collection",lights = {}},
	}}, -- end lights_data
	
	--Countries = {"USA","Germany","Italy","UK","France"},
}

add_aircraft(P_38D)